#!/usr/bin/python
# -*- coding: utf-8 -*-

import argparse
from asflight import AsfLight

# --------------------


def main():

    # all consonants
    phn_cons = [ 'b','c','C','d','D','w','W','f','g','h','x','G','j','k','l','L','m','M','H','n','J','N','p','r','P','R','Q','s','S','t','T','v','z','Z','!' ]

    # consonants without r, l, P, L
    phn_cons_m_left = [ 'b','c','C','d','D','w','W','f','g','h','x','G','j','k','m','M','H','n','J','N','p','R','Q','s','S','t','T','v','z','Z','!' ]

    # consonants without r, l, P, L, J
    phn_cons_m_right = [ 'b','c','C','d','D','w','W','f','g','h','x','G','j','k','m','M','H','n','N','p','R','Q','s','S','t','T','v','z','Z','!' ]

    parser = argparse.ArgumentParser( description = 'Convert ASF file to MLF.' )

    parser.add_argument( type=str, dest="asf_in", help="input ASF file", metavar="ASF_IN" )

    parser.add_argument( type=str, dest="asf_out", help="input ASF file", metavar="ASF_OUT" )

    parser.add_argument( "-c", "--code-page", type=str, dest="code_page",
                         help="encoding of all files, default value: %(default)s", default="utf-8" )

    # parse arguments
    args = parser.parse_args()

    asf = AsfLight( args.asf_in )

    for utt_name, asf_labels in asf.utts.iteritems():

        n_labels = len( asf_labels )

        for lab_idx in range( len( asf_labels ) ):

            curr_lab = asf_labels[ lab_idx ]
            prev_lab = asf_labels[ lab_idx-1 ] if ( lab_idx > 0 ) else None
            next_lab = asf_labels[ lab_idx+1 ] if ( lab_idx+1 < n_labels ) else None

            word_beg = ( curr_lab['word'] != '.' )
            word_end = ( next_lab is None ) or ( next_lab['word'] != '.' )

            if curr_lab['phone'] == 'n':
                if ( not word_end ) and ( next_lab['phone'] in [ 'g', 'k' ] ):
                    curr_lab['phone'] = 'N'

            elif curr_lab['phone'] == 'm':
                if ( not word_beg ) and ( prev_lab['phone'] in phn_cons_m_left ) and ( word_end or ( next_lab['phone'] in phn_cons_m_right ) ):
                    curr_lab['phone'] = 'H'

                elif ( not word_end ) and ( next_lab['phone'] in [ 'f', 'v' ] ):
                    curr_lab['phone'] = 'M'

            elif curr_lab['phone'] == 'x':
                if next_lab and ( next_lab['phone'] in [ 'b','d','D','w','W','g','h','G','z','Z' ] ):  # voiced paired consonants without 'v'
                    curr_lab['phone'] = 'G'

            elif curr_lab['phone'] == 'l':
                if ( not word_beg ) and ( prev_lab['phone'] in phn_cons ) and ( word_end or ( next_lab['phone'] in phn_cons ) ):
                    curr_lab['phone'] = 'L'

            elif curr_lab['phone'] == 'r':
                if ( not word_beg ) and ( prev_lab['phone'] in phn_cons ) and ( word_end or ( next_lab['phone'] in phn_cons ) ):
                    curr_lab['phone'] = 'P'

    asf.write( args.asf_out )


#
# ----------------------------------
#

# run the main program
if ( __name__ == "__main__" ):
    main()
